<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityImage
 * @package Cms\DashParser\Entity
 */
class EntityImage implements
    EntityBlockInterface,
    EntityLinkableInterface,
    EntityPositionableInterface,
    EntitySizableInterface
{

    use EntityPositionableTrait;
    use EntityLinkableTrait;
    use EntitySizableTrait;

    /**
     * @var string
     */
    private $src;

    /**
     * @var string
     */
    private $copy;

    /**
     * @var string
     */
    private $legend;

    /**
     * EntityImage constructor.
     * @param string $src
     * @param string $linkUrl
     * @param int $width
     * @param int $height
     * @param string $copy
     * @param string $legend
     * @param string|EntityPositionEnum $position
     * @param null|string $linkTarget
     * @param null|string $linkTitle
     * @param null|string $linkRel
     * @throws \InvalidArgumentException
     */
    public function __construct(
        $src,
        $linkUrl,
        $width,
        $height,
        $copy,
        $legend,
        $position,
        $linkTarget = null,
        $linkTitle = null,
        $linkRel = null
    ) {
        $this->src = $src;
        $this->copy = $copy;
        $this->legend = $legend;

        $this->setWidth($width);
        $this->setHeight($height);
        $this->setLink($linkUrl, $linkTarget, $linkTitle, $linkRel);
        $this->setPosition($position);
    }

    /**
     * @return string
     */
    public function getLegend() : string
    {
        return $this->legend;
    }

    /**
     * @param string $legend
     * @return $this
     */
    public function setLegend($legend)
    {
        $this->legend = $legend;
        return $this;
    }

    /**
     * @return string
     */
    public function getCopy() : string
    {
        return $this->copy;
    }

    /**
     * @param string $copy
     * @return $this
     */
    public function setCopy($copy)
    {
        $this->copy = $copy;
        return $this;
    }

    /**
     * @return string
     */
    public function getSrc() : string
    {
        return $this->src;
    }

    /**
     * @param string $src
     * @return $this
     */
    public function setSrc($src)
    {
        $this->src = $src;
        return $this;
    }
}
