<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityLinkHandler
 * @package Cms\DashParser\Entity
 */
class EntityLinkHandler extends AbstractEntityHandler
{

    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'LINK')) {
            return null;
        }
        return new EntityLink(
            $mapItem['data']['url'],
            !empty($mapItem['data']['target']) ? $mapItem['data']['target'] :
                (!empty($mapItem['data']['url_target']) ? $mapItem['data']['url_target'] :
                    (!empty($mapItem['data']['link_target']) ? $mapItem['data']['link_target'] : null)),
            !empty($mapItem['data']['title']) ? $mapItem['data']['title'] :
                    (!empty($mapItem['data']['link_title']) ? $mapItem['data']['link_title'] : null),
            !empty($mapItem['data']['rel']) ? $mapItem['data']['rel'] :
                    (!empty($mapItem['data']['link_rel']) ? $mapItem['data']['link_rel'] : null),
            !empty($mapItem['data']['button_profil']) ? $mapItem['data']['button_profil'] : null
        );
    }
}
