<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityTableHandler
 * @package Cms\DashParser\Entity
 */
class EntityTableHandler extends AbstractEntityHandler
{
    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'TABLE')) {
            return null;
        }

        return new EntityTable(
            (int)$mapItem['data']['cols'],
            (int)$mapItem['data']['rows'],
            $mapItem['data']['tableData']
        );
    }
}
