<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityInterface;
use Cms\DashParser\Entity\EntityTable;

/**
 * Class HtmlEntityTableConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityTableConverter implements HtmlEntityConverterInterface
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityTable) {
            return null;
        }

        $block = $doc->createElement('table');
        foreach ($entity->getData() as $lineData) {
            $tableRow = $doc->createElement('tr');
            foreach ($lineData as $colData) {
                $tableCol = $doc->createElement('td');

                $cell = $this->applyStyle($doc, $tableCol, $colData);
                $cell->textContent = $colData['value'];

                $this->applyPosition($tableCol, $colData);
                $tableRow->appendChild($tableCol);
            }
            $block->appendChild($tableRow);
        }
        return $block;
    }

    /**
     * @param \DOMDocument $doc
     * @param \DOMElement $cell
     * @param array $colData
     * @return \DOMElement|\DOMNode
     */
    private function applyStyle(\DOMDocument $doc, \DOMElement $cell, array $colData)
    {
        if (!empty($colData['bold'])) {
            $bold = $doc->createElement('strong');
            $cell = $cell->appendChild($bold);
        }
        if (!empty($colData['italic'])) {
            $italic = $doc->createElement('i');
            $cell = $cell->appendChild($italic);
        }
        if (!empty($colData['underline'])) {
            $underline = $doc->createElement('u');
            $cell = $cell->appendChild($underline);
        }
        return $cell;
    }

    /**
     * @param \DOMElement $cell
     * @param array $colData
     */
    private function applyPosition(\DOMElement $cell, array $colData)
    {
        if (!empty($colData['position'])) {
            $class = explode(' ', $cell->getAttribute('class'));
            $class[] = 'align-' . $colData['position'];
            $cell->setAttribute('class', implode(' ', array_filter($class)));
        }
    }
}
