<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityTable
 * @package Cms\DashParser\Entity
 */
class EntityTable implements EntityBlockInterface
{
    /** @var int */
    private $cols;

    /** @var int */
    private $rows;

    /** @var array */
    private $data;

    /**
     * EntityTable constructor.
     * @param int $cols
     * @param int $rows
     * @param array $data
     */
    public function __construct(int $cols, int $rows, array $data = [])
    {
        $this->cols = $cols;
        $this->rows = $rows;
        $this->data = $data;
    }

    /**
     * @return int
     */
    public function getCols() : int
    {
        return $this->cols;
    }

    /**
     * @return int
     */
    public function getRows() : int
    {
        return $this->rows;
    }

    /**
     * @return array
     */
    public function getData() : array
    {
        return $this->data;
    }
}
