<?php

namespace Cms\DashParser;

use Cms\DashParser\Block\BlockInterface;
use Cms\DashParser\Entity\EntityInterface;

/**
 * Class DashParser
 * @package Cms\DashParser
 */
class DashParser
{

    /**
     * @var array
     */
    private $blocksCollection;

    /**
     * @var array
     */
    private $entityCollection;


    /**
     * DashParser constructor.
     * @param array $blocksCollection
     * @param array $entityCollection
     */
    public function __construct(array $blocksCollection = [], array $entityCollection = [])
    {
        $this->blocksCollection = $blocksCollection;
        $this->entityCollection = $entityCollection;
    }


    /**
     * @param DashContentInterface $content
     * @param HandlerInterface $entityHandler
     * @param HandlerInterface $blockHandler
     * @return DashParser
     */
    public static function parse(
        DashContentInterface $content,
        HandlerInterface $entityHandler,
        HandlerInterface $blockHandler
    ) : DashParser {
        $entityMapCollection = [];
        if (\is_array($content->getEntityMap()) && !empty($content->getEntityMap())) {
            $entityMapCollection = [];
            foreach ($content->getEntityMap() as $id => $mapItem) {
                $entity = $entityHandler->handle($mapItem);
                if (!empty($entity) && $entity instanceof EntityInterface) {
                    $entityMapCollection[$id] = $entity;
                }
            }
        }

        $blocksCollection = [];
        if (\is_array($content->getBlocks()) && !empty($content->getBlocks())) {
            $blocksCollection = [];
            foreach ($content->getBlocks() as $blockData) {
                $block = $blockHandler->handle($blockData);
                if (!empty($block) && $block instanceof BlockInterface) {
                    // ajout des données
                    if (!empty($blockData['entityRanges'])
                        && \is_array($blockData['entityRanges'])
                    ) {
                        $block->setEntityRanges($blockData['entityRanges']);
                    }
                    if (!empty($blockData['inlineStyleRanges'])
                        && \is_array($blockData['inlineStyleRanges'])
                    ) {
                        $block->setInlineStyleRanges($blockData['inlineStyleRanges']);
                    }
                    // ajout dans la collection
                    $blocksCollection[] = $block;
                }
            }
        }

        return new self($blocksCollection, $entityMapCollection);
    }

    /**
     * @return array
     */
    public function getEntityCollection() : array
    {
        return $this->entityCollection;
    }

    /**
     * @return array
     */
    public function getBlocksCollection() : array
    {
        return $this->blocksCollection;
    }
}
