<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityResourceHandler
 * @package Cms\DashParser\Entity
 */
class EntityResourceHandler extends AbstractEntityHandler
{

    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'RESOURCE')) {
            return null;
        }
        return new EntityResource(
            $mapItem['data']['id'],
            $mapItem['data']['provider'],
            $mapItem['data']['type'],
            !empty($mapItem['data']['label']) ? $mapItem['data']['label'] : null
        );
    }
}
