<?php


namespace Cms\DashParser\Entity;

/**
 * Interface EntityLinkableInterface
 * @package Cms\DashParser\Entity
 */
interface EntityLinkableInterface extends EntityInterface
{

    /**
     * @return string
     */
    public function getLink();

    /**
     * @return string
     */
    public function getLinkTarget();

    /**
     * @return string
     */
    public function getLinkTitle();

    /**
     * @return string
     */
    public function getLinkRel();

    /**
     * @return string
     */
    public function getButtonProfile();

    /**
     * @param string $link
     * @param null|string $linkTarget
     * @param null $linkTitle
     * @param null $linkRel
     * @param null $buttonProfile
     * @return $this
     */
    public function setLink($link, $linkTarget = '_self', $linkTitle = null, $linkRel = null, $buttonProfile = null);
}
