<?php

namespace Cms\DashParser\Block;

use Cms\DashParser\AbstractHandler;

/**
 * Class AbstractBlockHandler
 * @package Cms\DashParser\Block
 */
abstract class AbstractBlockHandler extends AbstractHandler
{

    /**
     * Check validity of block for type
     * @param array $mapItem
     * @param string $type
     * @return bool
     */
    final protected function isValidBlock($mapItem, $type = null) : bool
    {
        $mapType = $this->getBlocType($mapItem);
        return $mapType !== null && (empty($type) || $mapType === strtolower($type));
    }

    /**
     * @param array $mapItem
     * @return string|null
     */
    final protected function getBlocType($mapItem) : ?string
    {
        return \is_array($mapItem)
        && !empty($mapItem['type']) ? strtolower($mapItem['type']) : null;
    }
}
