<?php


namespace Cms\DashParser\Block;

/***
 * Class BlockParagraphListItem
 * @package Cms\DashParser\Block
 */
class BlockListItem implements BlockInterface, BlockTextAwareInterface
{
    use BlockRangesTrait;
    use BlockTextAwareTrait;

    /**
     * @var bool
     */
    private $ordered;


    /**
     * BlockListItem constructor.
     * @param string $text
     * @param bool $ordered
     */
    public function __construct($text, $ordered = true)
    {
        $this->ordered = $ordered;
        $this->setText($text);
    }


    /**
     * @return boolean
     */
    public function isOrdered() : bool
    {
        return $this->ordered;
    }

    /**
     * @param boolean $ordered
     * @return $this
     */
    public function setOrdered($ordered)
    {
        $this->ordered = $ordered;
        return $this;
    }
}
