<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityEmbedHandler
 * @package Cms\DashParser\Entity
 */
class EntityEmbedHandler extends AbstractEntityHandler
{

    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'EMBED')) {
            return null;
        }
        return new EntityEmbed(
            $mapItem['data']['url'],
            !empty($mapItem['data']['thumb_url']) ? $mapItem['data']['thumb_url'] : null,
            $mapItem['data']['width'] ?? null,
            $mapItem['data']['height'] ?? null
        );
    }
}
