<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityTopListHandler
 * @package Cms\DashParser\Entity
 */
class EntityTopListHandler extends AbstractEntityHandler
{
    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'TOPLIST')) {
            return null;
        }

        return new EntityTopList(
            $mapItem['data']['topList']
        );
    }
}
