<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityInterface;
use Cms\DashParser\Entity\EntitySummary;

/**
 * Class HtmlEntitySummaryConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntitySummaryConverter implements HtmlEntityConverterInterface
{

    /**
     * @inheritDoc
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntitySummary) {
            return null;
        }

        // placeholder for replacement
        if (!$entity->getSummary()) {
            return $doc->createElement('div', '##summary##');
        }

        // on vide le contenu
        $summary = $doc->createElement('div');
        $summary->setAttribute('class', 'summary-art');
        $summaryTitle = $doc->createElement('div', 'Sommaire');
        $summaryTitle->setAttribute('class', 'summary-title');
        $summary->appendChild($summaryTitle);

        $chapter = ['currentLevel' => null, 'lists' => [$doc->createElement('ol')]];
        foreach ($entity->getSummary() as $summaryData) {
            $summaryItemLink = $doc->createElement('a', $summaryData['text']);
            $summaryItemLink->setAttribute('href', '#hl_' . $summaryData['text']);

            $summaryItem = $doc->createElement('li');
            $summaryItem->appendChild($summaryItemLink);

            if ($chapter['currentLevel'] === null) {
                $chapter['currentLevel'] = $summaryData['level'];
            } elseif ($chapter['currentLevel'] < $summaryData['level']) {
                array_unshift($chapter['lists'], $doc->createElement('ol'));
            } elseif ($chapter['currentLevel'] > $summaryData['level']) {
                $parentList = array_shift($chapter['lists']);
                $chapter['lists'][0]->appendChild($parentList);
            }
            $chapter['currentLevel'] = $summaryData['level'];

            $chapter['lists'][0]->appendChild($summaryItem);
        }
        $summary->appendChild($chapter['lists'][0]);

        return $summary;
    }
}
