<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityImage;
use Cms\DashParser\Entity\EntityInterface;
use Cms\DashParser\Entity\EntityPositionEnum;
use Cms\DashParser\Entity\EntityTopList;

/**
 * Class HtmlEntityTopListConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityTopListConverter implements HtmlEntityConverterInterface
{

    /** @var \Cms\DashParser\Serializer\HtmlEntityImageConverter */
    private $imageConverter;

    /**
     * HtmlEntityTopListConverter constructor.
     * @param \Cms\DashParser\Serializer\HtmlEntityImageConverter $imageConverter
     */
    public function __construct(HtmlEntityImageConverter $imageConverter)
    {
        $this->imageConverter = $imageConverter;
    }

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityTopList) {
            return null;
        }

        $defList = $doc->createElement('dl');
        $defList->setAttribute('class', 'toplist-art');

        $lines = $entity->getData();
        if (empty($lines)) {
            return null;
        }

        foreach ($lines as $lineData) {
            // construction du titre
            $titleDef = $defLink = $doc->createElement('dt');

            if (!empty($lineData['link'])) {
                $defLink = $doc->createElement('a');
                $defLink->setAttribute('href', $lineData['link']);
                if (!empty($lineData['link_target']) && $lineData['link_target'] !== '_self') {
                    $defLink->setAttribute('target', $lineData['link_target']);
                }
            }

            $rankSpan = $doc->createElement('span', $lineData['rank']);
            $rankSpan->setAttribute('class', 'num-toplist');
            $defLink->appendChild($rankSpan);

            $titleSpan = $doc->createElement('span', $lineData['title']);
            $titleSpan->setAttribute('class', 'title-toplist');
            $defLink->appendChild($titleSpan);

            if (!empty($lineData['link'])) {
                $titleDef->appendChild($defLink);
            }
            $defList->appendChild($titleDef);

            // construction du texte
            $defContent = $doc->createElement('dd');
            $defContent->setAttribute('class', 'content-toplist');

            if (!empty($lineData['url'])) {
                $imageEntity = new EntityImage(
                    $lineData['url'],
                    '',
                    414,
                    200,
                    '',
                    '',
                    EntityPositionEnum::CENTER
                );
                $defImg = $this->imageConverter->getEntityNode($doc, $imageEntity, $lineData['title']);
                $defContent->appendChild($defImg);
                unset($imageEntity);
            }

            $defText = $doc->createTextNode($lineData['text']);
            $defContent->appendChild($defText);

            $defList->appendChild($defContent);
        }

        return $defList;
    }
}
