<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityLinkableTrait
 * @package Cms\DashParser\Entity
 */
trait EntityLinkableTrait
{

    /** @var  string */
    protected $link;

    /** @var  string */
    protected $linkTarget;

    /** @var  string */
    protected $linkTitle;

    /** @var  string */
    protected $linkRel;

    /** @var string */
    protected $buttonProfile;

    /**
     * @param string $link
     * @param null|string $linkTarget
     * @param null|string $linkTitle
     * @param null|string $linkRel
     * @param null $buttonProfile
     * @return $this
     */
    public function setLink($link, $linkTarget = '_self', $linkTitle = null, $linkRel = null, $buttonProfile = null)
    {
        $this->link = $link;
        $this->linkTarget = $linkTarget;
        $this->linkTitle = $linkTitle;
        $this->linkRel = $linkRel;
        $this->buttonProfile = $buttonProfile;
        return $this;
    }

    /**
     * @return string
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @return string
     */
    public function getLinkTarget()
    {
        return $this->linkTarget;
    }

    /**
     * @return string
     */
    public function getLinkTitle()
    {
        return $this->linkTitle;
    }

    /**
     * @return string
     */
    public function getLinkRel()
    {
        return $this->linkRel;
    }

    /**
     * @param string $linkRel
     * @return $this
     */
    public function setLinkRel($linkRel)
    {
        $this->linkRel = $linkRel;
        return $this;
    }

    /**
     * @param string $linkTitle
     * @return $this
     */
    public function setLinkTitle($linkTitle)
    {
        $this->linkTitle = $linkTitle;
        return $this;
    }

    /**
     * @param string $linkTarget
     * @return $this
     */
    public function setLinkTarget($linkTarget)
    {
        $this->linkTarget = $linkTarget;
        return $this;
    }

    /**
     * @return string
     */
    public function getButtonProfile()
    {
        return $this->buttonProfile;
    }

    /**
     * @param string $buttonProfile
     * @return $this
     */
    public function setButtonProfile($buttonProfile)
    {
        $this->buttonProfile = $buttonProfile;
        return $this;
    }
}
