<?php


namespace Cms\DashParser\Block;

/**
 * Class BlockHeadline
 * @package Cms\DashParser\Block
 */
class BlockHeadline implements BlockInterface, BlockTextAwareInterface
{
    use BlockRangesTrait;

    /**
     * @var string
     */
    private $headLine;

    /**
     * @var int
     */
    private $level;

    /**
     * BlockHeadline constructor.
     * @param string $headLine
     * @param $level
     */
    public function __construct($headLine, $level)
    {
        $this->headLine = $headLine;
        $this->level = $level;
    }

    /**
     * @return int
     */
    public function getLevel() : int
    {
        return $this->level;
    }

    /**
     * @param int $level
     * @return $this
     */
    public function setLevel($level)
    {
        $this->level = $level;
        return $this;
    }

    /**
     * @return string
     */
    public function getHeadLine() : string
    {
        return $this->headLine;
    }

    /**
     * @param string $headLine
     * @return $this
     */
    public function setHeadLine($headLine)
    {
        $this->headLine = $headLine;
        return $this;
    }

    /**
     * @return string
     */
    public function getText() : string
    {
        return $this->getHeadLine();
    }

    /**
     * @param string $text
     * @return $this
     */
    public function setText($text)
    {
        return $this->setHeadLine($text);
    }
}
