<?php


namespace Cms\DashParser\Block;

/**
 * Class BlockParagraph
 * @package Cms\DashParser\Block
 */
class BlockParagraph implements BlockInterface, BlockTextAwareInterface
{
    use BlockRangesTrait;
    use BlockTextAwareTrait;

    /** @var string|null */
    protected $placement;

    /**
     * BlockParagraph constructor.
     * @param string $text
     * @param string|null $placement
     */
    public function __construct($text, ?string $placement)
    {
        $this->setText($text);
        if (BlockPositionEnum::isValid($placement)) {
            if ($placement === BlockPositionEnum::JUSTIFY) {
                $placement = BlockPositionEnum::FULL;
            }
            $this->placement = $placement;
        }
    }

    /**
     * @return string|null
     */
    public function getPlacement() : ?string
    {
        return $this->placement;
    }
}
