<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityBeforeAfter
 * @package Cms\DashParser\Entity
 */
class EntityBeforeAfter implements EntityBlockInterface
{
    /**
     * @var float
     */
    private $ratio;

    /**
     * @var array
     */
    private $asset1 = [];

    /**
     * @var array
     */
    private $asset2 = [];

    /**
     * EntityBeforeAfter constructor.
     * @param float $ratio
     * @param array $asset1
     * @param array $asset2
     */
    public function __construct(float $ratio, array $asset1, array $asset2)
    {
        $this->ratio = $ratio;

        if (!$this->validateAsset($asset1)) {
            trigger_error('asset1 is invalid', E_USER_WARNING);
        } else {
            $this->asset1 = $asset1;
        }

        if (!$this->validateAsset($asset2)) {
            trigger_error('asset2 is invalid', E_USER_WARNING);
        } else {
            $this->asset2 = $asset2;
        }
    }

    /**
     * @param array $asset
     * @return bool
     */
    private function validateAsset(array $asset): bool
    {
        if (empty($asset['url'])) {
            return false;
        }

        return true;
    }

    /**
     * @return float
     */
    public function getRatio(): float
    {
        return $this->ratio;
    }

    /**
     * @return array
     */
    public function getAsset1(): array
    {
        return $this->asset1;
    }

    /**
     * @return array
     */
    public function getAsset2(): array
    {
        return $this->asset2;
    }
}
