<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityBeforeAfterHandler
 * @package Cms\DashParser\Entity
 */
class EntityBeforeAfterHandler extends AbstractEntityHandler
{

    /**
     * @inheritDoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'BEFOREAFTER')) {
            return null;
        }
        [$divde, $divor] = explode('/', $mapItem['data']['beforeAfter']['ratio']);

        return new EntityBeforeAfter(
            $divor / $divde,
            [
                'url' => $mapItem['data']['beforeAfter']['asset1_url'],
                'legend' => $mapItem['data']['beforeAfter']['asset1_legend'] ?? null,
                'credit' => $mapItem['data']['beforeAfter']['asset1_credit'] ?? null,
            ],
            [
                'url' => $mapItem['data']['beforeAfter']['asset2_url'],
                'legend' => $mapItem['data']['beforeAfter']['asset2_legend'] ?? null,
                'credit' => $mapItem['data']['beforeAfter']['asset2_credit'] ?? null,
            ]
        );
    }
}
