<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityInterface;
use Cms\DashParser\Entity\EntityResource;

/**
 * Class HtmlEntityResourceConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityResourceConverter implements HtmlEntityConverterInterface
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityResource) {
            return null;
        }

        $block = $doc->createElement('p', $entity->getLabel());
        $block->setAttribute('style', 'display: none');
        $block->setAttribute('data-ref', $entity->getRef());
        $block->setAttribute('data-type', $entity->getType());
        $block->setAttribute('data-provider', $entity->getProvider());
        return $block;
    }
}
