<?php

namespace POM\Service\Mysql;

use POM\Service\AdapterPdoAbstract;

/**
 * Class Adapter
 * @package POM\Service\Mysql
 */
class Adapter extends AdapterPdoAbstract
{

    /**
     * @var string
     */
    private $_charset = 'utf8';


    /**
     * @param string $dsn
     * @param string $user
     * @param string $pass
     * @param array $opts
     * @throws \InvalidArgumentException
     */
    public function __construct($dsn, $user, $pass, array $opts = [])
    {
        if (!$dsn || !preg_match("@^mysql:@", $dsn)) {
            throw new \InvalidArgumentException('Mysql DSN invalid, it must match : ^mysql:host=.+;dbname=.+$(;port=.+)?');
        }
        parent::__construct($dsn, $user, $pass, array_merge([
            \PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
            \PDO::MYSQL_ATTR_FOUND_ROWS => true,
            \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
        ], $opts));
        if (!empty($opts['charset'])) {
            $this->_charset = $opts['charset'];
        }
    }

    /**
     * @inheritdoc
     */
    public function connect()
    {
        $result = parent::connect();
        if ($result === true && !empty($this->_charset)) {
            $this->exec("SET NAMES " . $this->_charset);
        }
        return $result;
    }
}