<?php

namespace POM;

/**
 * Class IdentityMap
 * @package POM
 */
class IdentityMap implements IdentityMapInterface
{

    /**
     * @var \SplObjectStorage
     */
    private $objectToId;

    /**
     * @var array
     */
    private $idToObject;

    /**
     * Start new IdentityMap
     */
    public function __construct()
    {
        $this->objectToId = new \SplObjectStorage();
        $this->idToObject = [];
    }

    /**
     * Supprime l'objet de la table
     * @param string $key
     */
    public function removeObject($key)
    {
        $object = $this->idToObject[$key];
        unset($this->objectToId[$object], $this->idToObject[$key]);
    }

    /**
     * Stock l'objet
     * @param string $key
     * @param mixed $object
     * @return void
     */
    public function storeObject($key, $object)
    {
        $this->idToObject[$key] = $object;
        $this->objectToId[$object] = $key;
    }

    /**
     * Verifie si la clé existe déjà dans le storage
     * @param string $key
     * @return bool
     */
    public function hasId($key)
    {
        return isset($this->idToObject[$key]);
    }

    /**
     * Verifie si l'objet existe déjà dans le storage
     * @param mixed $object
     * @return bool
     */
    public function hasObject($object)
    {
        return isset($this->objectToId[$object]);
    }

    /**
     * Renvoi l'objet associé a la clé ou null si non existant
     * @param string $key
     * @return mixed
     */
    public function getObject($key)
    {
        if (false === $this->hasId($key)) {
            return null;
        }
        return $this->idToObject[$key];
    }

    /**
     * Renvoi l'id associé a un objet dans le storage
     * @param mixed $object
     * @return string
     */
    public function getObjectId($object)
    {
        if (false === $this->hasObject($object)) {
            return null;
        }
        return $this->objectToId[$object];
    }
}
