<?php

namespace POM\Service\Postgres;

use POM\Service\AdapterPdoAbstract;

/**
 * Class Adapter
 * @package POM\Service\Postgres
 */
class Adapter extends AdapterPdoAbstract
{

    /**
     * @var string
     */
    private $charset = 'utf8';

    /** @var bool  */
    protected $nestableTransaction = true;

    /**
     * @param string $dsn
     * @param string $user
     * @param string $pass
     * @param array $opts
     * @throws \InvalidArgumentException
     */
    public function __construct($dsn, $user, $pass, array $opts = array())
    {
        if (!$dsn || !preg_match("@^pgsql:@", $dsn)) {
            throw new \InvalidArgumentException(
                'Postgres DSN invalid, it must match : ^pgsql:host=.+;dbname=.+(;port=.+)?$'
            );
        }
        parent::__construct($dsn, $user, $pass, $opts);
        if (!empty($opts['charset'])) {
            $this->charset = $opts['charset'];
        }
    }

    /**
     * @inheritdoc
     */
    public function connect()
    {
        $result = parent::connect();
        if ($result === true && !empty($this->charset)) {
            $this->exec("SET NAMES " . $this->charset);
        }
        return $result;
    }
}
