<?php

namespace Exemple\Mapper;

use POM\DomainObjectInterface;
use POM\MapperPdoAbstract;
use POM\Service\AdapterPdoAbstract;

/**
 * Class Post
 * @package Exemple\Mapper
 */
class Post extends MapperPdoAbstract {

	/**
	 * @param AdapterPdoAbstract $adapter
	 */
	public function __construct(AdapterPdoAbstract $adapter) {
		parent::__construct($adapter, 'server_http_config', ['id']);
	}

    /**
     * @param \POM\DomainObjectInterface $object
     * @return bool
     */
	public function insert(DomainObjectInterface &$object) {
		$object['date_update'] = new \DateTime();
		return parent::insert($object);
	}

    /**
     * @param \POM\DomainObjectInterface $object
     * @return mixed
     */
	public function update(DomainObjectInterface &$object) {
		$object['date_update'] = new \DateTime();
		return parent::update($object);
	}

}