<?php

namespace POM\Service\Mysql;

use POM\Service\AdapterPdoAbstract;

/**
 * Class Adapter
 * @package POM\Service\Mysql
 */
class Adapter extends AdapterPdoAbstract
{

    /**
     * @param string $dsn
     * @param string $user
     * @param string $pass
     * @param array $opts
     * @throws \InvalidArgumentException
     */
    public function __construct($dsn, $user, $pass, array $opts = [])
    {
        if (!$dsn || !preg_match('@^mysql:@', $dsn)) {
            throw new \InvalidArgumentException(
                'Mysql DSN invalid, it must match : ^mysql:host=.+;dbname=.+$(;port=.+)?'
            );
        }
        if (!empty($opts['charset'])) {
            $dsn .= ';charset=' . $opts['charset'];
        } else {
            $dsn .= ';charset=utf8';
        }
        if (!empty($opts['timeout'])) {
            $dsn .= ';connect_timeout=' . $opts['timeout'];
        }
        parent::__construct($dsn, $user, $pass, array_merge([
            \PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
            \PDO::MYSQL_ATTR_COMPRESS => true,
            \PDO::MYSQL_ATTR_FOUND_ROWS => true,
            \PDO::ATTR_EMULATE_PREPARES => false,
        ], $opts));
        $this->nestableTransaction = true;
    }
}
