<?php

namespace POM\PredefinedType;

use POM\DomainObjectAbstract;

/**
 * Class GpsLocationPoint
 * @package POM\PredefinedType
 * @property string $latitude
 * @property string $longitude
 */
class GpsLocationPoint extends DomainObjectAbstract implements PredefinedTypeInterface
{

    /** @var  string */
    protected $latitude;

    /** @var  string */
    protected $longitude;

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        $value = str_replace(',', '.', $value);
        parent::propertySet($offset, $value);
    }

    /**
     * @return string|null
     */
    public function sqlSerialize()
    {
        if ($this->latitude && $this->longitude) {
            return sprintf('POINT(%s %s)', $this->latitude, $this->longitude);
        }
        return null;
    }

    /**
     * @param string $serialized
     * @return void
     */
    public function sqlUnserialize($serialized)
    {
        if (preg_match('@POINT\(([0-9-\.]+) ([0-9-\.]+)\)@', $serialized, $matches)) {
            $this->propertySet('latitude', $matches[1]);
            $this->propertySet('longitude', $matches[2]);
        }
    }
}
