<?php


namespace POM;

/**
 * Class TypeFactory
 * @package POM
 */
class TypeFactory
{
    /**
     * @var array
     */
    protected static $registrer;

    /**
     * @param mixed $detectType
     * @param DomainObjectInterface $objectCaller
     * @return callable|null
     * @throws \ReflectionException
     */
    public static function getCallableForType($detectType, DomainObjectInterface $objectCaller)
    {
        $callable = null;

        // si le detect type est un tableau
        if (substr($detectType, - 2) === '[]') {
            $detectType = substr($detectType, 0, - 2);
            if (null === ($callable = TypeFactory::getCallableForType(
                $detectType,
                $objectCaller
            ))
            ) {
                return $callable;
            }
            return new TypeArray($callable);
        }

        // active le registrer
        $registrerKey = get_class($objectCaller) . $detectType;
        if (isset(self::$registrer[$registrerKey])) {
            return self::$registrer[$registrerKey];
        }

        // premiere detection pour le type simple
        if (TypePhpNative::validate($detectType)) {
            $callable = new TypePhpNative($detectType);
        } // deja un callable
        elseif (is_callable($detectType)) {
            $callable = $detectType;
        } // check des type class
        else {
            // check existance class
            $className = $detectType;
            if (!class_exists($className)) {
                $reflectCallerClass = new \ReflectionClass($objectCaller);
                $className = self::searchInNamespace($reflectCallerClass, $detectType);
            }

            if (!class_exists($className)) {
                $callable = null;
            } else {
                $reflectionClass = new \ReflectionClass($className);
                // on assign une valeur uniquement si une class est instantiable
                if ($reflectionClass->implementsInterface(\Serializable::class)) {
                    $callable = 'unserialize';
                } // instantiable
                elseif ($reflectionClass->isInstantiable()) {
                    $callable = new TypeClass($className);
                } // json decodable
                elseif ($reflectionClass->implementsInterface(\JsonSerializable::class)) {
                    return new TypeJson();
                }
            }
        }

        self::$registrer[$registrerKey] = $callable;
        return $callable;
    }

    /**
     * @param \ReflectionClass $reflectCallerClass
     * @param string $detectType
     * @return string
     */
    protected static function searchInNamespace(\ReflectionClass $reflectCallerClass, $detectType) : string
    {
        $namespaceName = $reflectCallerClass->getNamespaceName();
        if ($detectType{0} !== '\\') {
            $className = $namespaceName . '\\' . $detectType;
        } else {
            $className = $detectType;
        }
        if (!class_exists($className) && ($parentClass = $reflectCallerClass->getParentClass())) {
            return self::searchInNamespace($parentClass, $detectType);
        }
        return $className;
    }
}
