<?php

namespace POM;

/**
 * Class TypeClass
 * @package POM
 */
class TypeClass
{
    /**
     * @var string
     */
    private $className;

    /**
     * TypeClass constructor.
     * @param string $className
     */
    public function __construct($className)
    {
        $this->className = $className;
    }

    /**
     * @param mixed $value
     * @return mixed
     * @throws \ReflectionException
     */
    public function __invoke($value)
    {
        return $this->convert($value);
    }

    /**
     * @param mixed $value
     * @return mixed
     * @throws \ReflectionException
     */
    public function convert($value)
    {
        $reflectionClass = new \ReflectionClass($this->className);

        // tentative de decodage
        if ($reflectionClass->implementsInterface(\JsonSerializable::class)) {
            $value = (new TypeJson())->convert($value);
        }

        // si deja instancié
        if ($value instanceof $this->className) {
            return $value;
        }

        // si on rempli un domaine
        if ($reflectionClass->implementsInterface(DomainObjectInterface::class)) {
            /** @var DomainObjectInterface $object */
            $object = new $this->className();
            if (\is_array($value)) {
                $object->populate($value, true);
            }
        } // cas generique
        else {
            $object = new $this->className($value);
        }

        return $object;
    }
}
