<?php


namespace POM;

/**
 * Class TypePhpNative
 * @package POM
 */
class TypePhpNative
{
    /**
     * @var string
     */
    private $type;

    /**
     * TypePhpNative constructor.
     * @param string $type
     * @throws \InvalidArgumentException
     */
    public function __construct($type)
    {
        if ($type === 'bool') {
            $type = 'boolean';
        }
        if (!self::validate($type)) {
            throw new \InvalidArgumentException('Type pass ' . $type . ' is not take in charge');
        }
        $this->type = $type;
    }


    /**
     * @param string $type
     * @return bool
     */
    public static function validate($type) : bool
    {
        if ($type === 'bool') {
            $type = 'boolean';
        }
        switch ($type) {
            default:
                return false;
                break;
            case 'null':
            case 'array':
            case 'object':
            case 'boolean':
            case 'float':
            case 'int':
            case 'string':
                return true;
                break;
        }
    }

    /**
     * @param mixed $value
     * @return mixed
     */
    public function __invoke($value)
    {
        return $this->convert($value);
    }


    /**
     * @param mixed $value
     * @return mixed
     */
    public function convert($value)
    {
        settype($value, $this->type);
        return $value;
    }
}
