<?php


namespace POM;

/**
 * Class TypeArray
 * @package POM
 */
class TypeArray
{

    /** @var  callable */
    private $callable;

    /**
     * TypeArray constructor.
     * @param $callable
     */
    public function __construct($callable)
    {
        $this->callable = $callable;
    }

    /**
     * @param mixed $value
     * @return mixed
     */
    public function __invoke($value)
    {
        return $this->convert($value);
    }

    /**
     * @param \Traversable|array $value
     * @return mixed
     */
    public function convert($value)
    {
        if (!\is_array($value) && !$value instanceof \Traversable) {
            return $value;
        }
        if ($value instanceof \Iterator) {
            $value = iterator_to_array($value);
        }
        foreach ($value as &$item) {
            $item = \call_user_func($this->callable, $item);
        }
        return $value;
    }
}
