<?php

namespace POM\Service;

/**
 * Class AdapterAbstract
 * @package POM\Service
 */
abstract class AdapterAbstract implements AdapterInterface
{

    /**
     * @inheritdoc
     */
    public function fetchOne($query, array $bind = [])
    {
        $cursor = $this->fetch($query, $bind);
        if (!empty($cursor)) {
            $result = $cursor->current();
            unset($cursor);
            return $result;
        }
        return [];
    }

    /**
     * @inheritdoc
     */
    abstract public function fetch($query, array $bind = []);
}
