<?php

namespace POM\Service;

/**
 * Interface AdapterInterface
 * @package POM\Service
 */
interface AdapterInterface
{

    /**
     * @return bool
     */
    public function beginTransaction() : bool;

    /**
     * @return bool
     */
    public function commitTransaction() : bool;

    /**
     * @return bool
     */
    public function rollBackTransaction() : bool;

    /**
     * Renvoi une ligne seulement de la requete demandé sous forme de tableau
     * @param string $query
     * @param array $bind
     * @return array
     */
    public function fetchOne($query, array $bind = []);

    /**
     * Renvoi un curseur pour parcourir chaque ligne de la requete,
     * il faudra penser a détruire le curseur afin de libéré la resource
     * @param string $query
     * @param array $bind
     * @return \Iterator
     */
    public function fetch($query, array $bind = []);

    /**
     * Renvoi les resultats d'une colonne uniquement, soit son numero soit son nom
     * @param int|string $column
     * @param string $query
     * @param array $bind
     * @return \Iterator|null
     */
    public function fetchColumn($column, $query, array $bind = []);

    /**
     * Effectue une requête et renvoi le nombre de lignes affectées,
     * si $lastInsertId est fourni il est rempli avec le dernier ID inséré
     * @param string $query
     * @param array $bind
     * @param int $lastInsertId
     * @return int
     */
    public function exec($query, array $bind = [], &$lastInsertId = null);
}
